/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;

public class Snake
extends JPanel
implements ActionListener {
    private final int B_WIDTH = 300;
    private final int B_HEIGHT = 300;
    private final int DOT_SIZE = 10;
    private final int ALL_DOTS = 900;
    private final int RAND_POS = 29;
    private final int DELAY = 140;
    private final int[] x = new int[900];
    private final int[] y = new int[900];
    private int dots;
    private int apple_x;
    private int apple_y;
    private boolean leftDirection = false;
    private boolean rightDirection = true;
    private boolean upDirection = false;
    private boolean downDirection = false;
    private boolean inGame = true;
    private Timer timer;
    private Image ball;
    private Image apple;
    private Image head;

    public Snake() {
        this.initBoard();
    }

    private void initBoard() {
        this.addKeyListener(new TAdapter());
        this.setBackground(Color.black);
        this.setFocusable(true);
        this.setDoubleBuffered(true);
        this.setPreferredSize(new Dimension(300, 300));
        this.loadImages();
        this.initGame();
    }

    private void loadImages() {
        ImageIcon iid = this.createImageIcon("/dot.png");
        this.ball = iid.getImage();
        ImageIcon iia = this.createImageIcon("/apple.png");
        this.apple = iia.getImage();
        ImageIcon iih = this.createImageIcon("/head.png");
        this.head = iih.getImage();
    }

    protected ImageIcon createImageIcon(String path) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private void initGame() {
        this.dots = 3;
        int z = 0;
        while (z < this.dots) {
            this.x[z] = 50 - z * 10;
            this.y[z] = 50;
            ++z;
        }
        this.locateApple();
        this.timer = new Timer(140, this);
        this.timer.start();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.doDrawing(g);
    }

    private void doDrawing(Graphics g) {
        if (this.inGame) {
            g.drawImage(this.apple, this.apple_x, this.apple_y, this);
            int z = 0;
            while (z < this.dots) {
                if (z == 0) {
                    g.drawImage(this.head, this.x[z], this.y[z], this);
                } else {
                    g.drawImage(this.ball, this.x[z], this.y[z], this);
                }
                ++z;
            }
            Toolkit.getDefaultToolkit().sync();
        } else {
            this.gameOver(g);
        }
    }

    private void gameOver(Graphics g) {
        String msg = "Game Over";
        String msg2 = "\n Don't play to much, you must work!!";
        Font small = new Font("Helvetica", 1, 14);
        FontMetrics metr = this.getFontMetrics(small);
        g.setColor(Color.white);
        g.setFont(small);
        g.drawString(msg, (300 - metr.stringWidth(msg)) / 2, 150);
        g.drawString(msg2, (300 - metr.stringWidth(msg)) / 8, 165);
    }

    private void checkApple() {
        if (this.x[0] == this.apple_x && this.y[0] == this.apple_y) {
            ++this.dots;
            this.locateApple();
        }
    }

    private void move() {
        int z = this.dots;
        while (z > 0) {
            this.x[z] = this.x[z - 1];
            this.y[z] = this.y[z - 1];
            --z;
        }
        if (this.leftDirection) {
            this.x[0] = this.x[0] - 10;
        }
        if (this.rightDirection) {
            this.x[0] = this.x[0] + 10;
        }
        if (this.upDirection) {
            this.y[0] = this.y[0] - 10;
        }
        if (this.downDirection) {
            this.y[0] = this.y[0] + 10;
        }
    }

    private void checkCollision() {
        int z = this.dots;
        while (z > 0) {
            if (z > 4 && this.x[0] == this.x[z] && this.y[0] == this.y[z]) {
                this.inGame = false;
            }
            --z;
        }
        if (this.y[0] >= 300) {
            this.inGame = false;
        }
        if (this.y[0] < 0) {
            this.inGame = false;
        }
        if (this.x[0] >= 300) {
            this.inGame = false;
        }
        if (this.x[0] < 0) {
            this.inGame = false;
        }
        if (!this.inGame) {
            this.timer.stop();
        }
    }

    private void locateApple() {
        int r = (int)(Math.random() * 29.0);
        this.apple_x = r * 10;
        r = (int)(Math.random() * 29.0);
        this.apple_y = r * 10;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.inGame) {
            this.checkApple();
            this.checkCollision();
            this.move();
        }
        this.repaint();
    }

    private class TAdapter
    extends KeyAdapter {
        private TAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 37 && !Snake.this.rightDirection) {
                Snake.this.leftDirection = true;
                Snake.this.upDirection = false;
                Snake.this.downDirection = false;
            }
            if (key == 39 && !Snake.this.leftDirection) {
                Snake.this.rightDirection = true;
                Snake.this.upDirection = false;
                Snake.this.downDirection = false;
            }
            if (key == 38 && !Snake.this.downDirection) {
                Snake.this.upDirection = true;
                Snake.this.rightDirection = false;
                Snake.this.leftDirection = false;
            }
            if (key == 40 && !Snake.this.upDirection) {
                Snake.this.downDirection = true;
                Snake.this.rightDirection = false;
                Snake.this.leftDirection = false;
            }
        }
    }
}

